% Разряд конденсатора C через сопротивление R
clear all;   % Очистить Workspace 
% Выполним решение дифференциального уравнения разряда
syms Uo Uc(t) R C T(Uc)
Uc=dsolve(diff(Uc) == (Uo-Uc)/(R*C), Uc(0)==4.946)
% Зададим параметры схемы
Uo=0;                  % Напряжение в вольтах на входе
C=910e-12;             % Емкость в фарадах
R=200;                 % Сопротивление в омах
t=[0:10e-9:1000e-9];   % Время в секундах
y=eval(Uc);            % Подготовить график
plot(t,y);             % Прорисовать график

% Подготовить обратную функцию 
str=char(Uc);             % Преобразовать в строку 
str=strcat('Uc == ',str); % Подготовить строку уравнения
str=sym(str)              % Преобразовать к формату sym
T=solve(str)              % Найти решения уравнения
Uo=0;                     % Напряжение в вольтах на входе
C=910e-12;                % Емкость в фарадах
R=200;                    % Сопротивление в омах
Uc = 2.118                % Потенциал на конденсаторе
ts=eval(T)                % Время разряда до Uc


